import numpy as np

import decimal

def float_range(start, stop, step):
  while start <= stop:
    yield float(start)
    start += decimal.Decimal(step)


min_mparse = 0
max_mparse = 10
stepsize_mparse = 0.01

min_markedness = 0
max_mparkedness = 10
stepsize_markedness = 0.01

outfile = open('outfile_probspace.csv','w',encoding='utf8')
outfile.write('WeightOfNullParse,WeightOfSingleViolation,PredictedProbSingleViolating,PredictedProbDoublyViolating,JointProbDoublyViolating,Difference\n')
for mparse_weight in float_range(min_mparse,max_mparse,stepsize_mparse):
    for markedness_weight in float_range(min_markedness,max_mparkedness,stepsize_markedness):
        harmony_of_null_parse = mparse_weight
        harmony_of_singly_violating = markedness_weight
        harmony_of_doubly_violating = 2*markedness_weight
        outfile.write(str(mparse_weight)+','+str(markedness_weight)+',')
        # Null parse vs. singly-violating
        eh_null_single = np.exp(-harmony_of_null_parse)
        eh_alt_single = np.exp(-harmony_of_singly_violating)
        z_single = eh_alt_single+eh_null_single
        p_null_single =eh_null_single/z_single
        p_alt_single = eh_alt_single/z_single
        joint_prob = p_alt_single*p_alt_single
        outfile.write(str(p_alt_single)+',')

        # Null parse vs. doubly-violating
        eh_null_double = np.exp(-harmony_of_null_parse)
        eh_alt_double = np.exp(-harmony_of_doubly_violating)
        z_double = eh_alt_double + eh_null_double
        p_null_double = eh_null_double / z_double
        p_alt_double = eh_alt_double / z_double
        diff = joint_prob-p_alt_double
        outfile.write(str(p_alt_double)+','+str(joint_prob)+','+str(diff))
        outfile.write('\n')
outfile.close()



